<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CNews extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "news") {

			$this->__init();
			$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;

				case "item":
					return $this->Item();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"list"					=> "list.htm",

			"item"					=> "item.htm",
			"image"					=> "image.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		global $base;
		

		$text = $this->pageTitleBlock();
		$this->plugins["seo"]->PageMeta($text);

		$items = $this->_GetItemsPage(
			"	{$this->tables['plugin:news_items']} as c,
				{$this->tables['plugin:news_items_lang']} as l
			",
			$this->tpl_module["settings"]["set_ipp_items"],
			$_GET["page"],
			"
				c.item_id=l.item_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]} AND 
				item_status=1 AND item_date <=  " . time(),
			" item_date DESC "
			
		);
			

		$items["records"] = $this->ProcessItems($items["records"] , $items);

		$template = &$this->private->templates["list"];

		if ($this->tpl_module["settings"]["set_style"] == "blog-topics-clasic") {
			$this->tpl_module["settings"]["set_size"] = 
			$this->tpl_module["settings"]["set_size_lg"] = 
			$this->tpl_module["settings"]["set_size_md"] = 
			$this->tpl_module["settings"]["set_size_sm"] = 
			$this->tpl_module["settings"]["set_size_xs"] = "12";
		}
		
		$this->SetComments($this->tpl_module["settings"]["set_comments"], array("link" => $this->tpl_module["link"]));


		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$items["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$items["pages"] , 
						$items["page"] , 
						array(
							"first"	=> $this->tpl_module["link"] ,
							"all"	=> $this->tpl_module["link"] . "p{PAGE}",
						),
						$items["items"]
					),

					"text_title"	=> $text["text_title"],

					"_title"	=> $text["text_block_1_title"] ? $template->blockReplace("Title" , $text) : "",

				),
				$text ,
				$this->tpl_module,
				$this->tpl_module["settings"]		
			)
		);

	}

		
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items , $category) {

		$template = &$this->private->templates["list"];


		if (is_array($items)) {

			$elements = explode("," , $this->tpl_module["settings"]["set_elements"]);

			foreach ($items as $key => $val) {

				$val["link"] = $items[$key]["link"] = $this->tpl_module["link"] . $val["item_url"] . "/" . $val["item_id"] ;
				

				$items[$key]["social_links"] = $this->plugins["socialmedia"] && $this->tpl_module["settings"]["set_social_list"] ? $this->plugins["socialmedia"]->Share($val["link"], $val["item_title"]) : "";
				
				$this->ProcessElements($items[$key] , $elements , $template , "listing" , $this->tpl_module["settings"]);

			}			
		}
		

		return $items;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
		* @access
	*/
	function ProcessElements(&$item , $elements , $template, $type = "listing", $settings , $max = 0) {

			$item["_button"] = $item["_title"] = $item["_brief"] = $item["_author"] = $item["_date"] = $item["_date2"] = $item["_image"] = $item["_views"] = $item["_source"] = $item["_comments"] = $item["_comments2"] = "";			

			if (in_array("date" , $elements) ) {

				$item["date"] = CDate::ToStr($settings["set_date"],$item["item_date"]);

				$item["day"] = CDate::ToStr("d" ,$item["item_date"]);
				$item["month_3"] = CDate::ToStr("%b" ,$item["item_date"]);
				$item["month"] = CDate::ToStr("%B" ,$item["item_date"]);
				$item["year"] = CDate::ToStr("Y" ,$item["item_date"]);;

				$item["_date"] = $template->blockReplace("Date" , $item);
				$item["_date2"] = $template->blockExists("Date2") ? $template->blockReplace("Date2" , $item) : "";
			} 


			if (in_array("source" , $elements)) {

					$source_name = $source_link = "";

					if ($item["item_source_btn"]) {
						$source_name = $item["item_source_btn"];
					} 
					
					if ($item["item_source"]) {
						$source_link = $item["item_source"];

						if (!$source_name) {
							$tmp = parse_url($source_link);
							$source_name = $tmp["host"];
						}						
					}

					
					if ($source_link || $source_name) {					
						$item["_source"] = $template->blockreplace(
							$source_link && $source_name ? "SourceLink" : "SourceNoLink", 
							$item,
							array(
								"source_name"	=> $source_name,
								"source_link"	=> $source_link,
							)
						);
					}
			} 

			if (in_array("image" , $elements)) {
				$item["_image"] = $this->plugins["media"]->Gallery(
					$item["item_id"] , 
					$item["module_id"] , 
					$type == "listing" ? $item["link"] : "", 
					$type , 
					"html" , 
					array(
						"path" => "upload/news",
						"tn"	=> $settings["set_media_height"] ? "tn2" : "tn",
						"max"	=> $max,
						"display"	=> $type == "details" ? "player" : "gallery",
					)
				);
			}
			
			if (in_array("author" , $elements) && $item["item_author"]) {
				$item["_author"] = $template->blockReplace(
					"Author" , 
					$item
				);
			} 

			if (in_array("views" , $elements)) {
				$item["item_stats_views"] = FormatNumber($item["item_stats_views"]);
				$item["_views"] = $template->blockReplace(
					"Views" , 
					$item
				);
			} 

			if (in_array("brief" , $elements) && $template->blockExists("Brief")) {
				$item["_brief"] = $template->blockReplace(
					"Brief" , 
					$item
				);
			} 

			if (in_array("title" , $elements) && $template->blockExists("Title")) {
				$item["_title"] = $template->blockReplace(
					"Title" , 
					$item
				);
			} 

			if (in_array("button" , $elements) && $template->blockExists("Button")) {
				$item["_button"] = $template->blockReplace(
					"Button" , 
					$item
				);
			} 


			if (in_array("comments" , $elements) && $settings["set_comments"]) {

				$item["item_stats_comments"] = $this->plugins["comments"]->CommentsCount(
					$settings["set_comments"],
					$item["link"],
					$item["item_stats_comments"]
				);
				$item["_comments"] = $template->blockReplace("Comments" , $item);
				$item["_comments2"] = $template->blockExists("Comments2") ? $template->blockReplace("Comments2" , $item) : "";

			} 
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Item() {

		$item = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:news_items']} as i,
				{$this->tables['plugin:news_items_lang']} as il
			WHERE
				i.item_id = il.item_id AND 
				il.lang_id = {$this->tpl_module[lang_id]} AND 
				i.item_id = %d AND 
				i.item_status = 1 AND 
				i.item_date <= %d
			",
			array($_GET["item_id"] , time())
		);

		if (!is_array($item)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		$this->db->QueryUpdate(
			$this->tables["plugin:news_items"],
			array(
				"item_stats_views"	=> $item["item_stats_views"] + 1
			),
			"item_id={$item[item_id]}"
		);


		$item["link"] = $this->tpl_module["link"] . $item["item_url"] . "/" . $item["item_id"];
		$elements = explode("," , $this->tpl_module["settings"]["set_elements_details"]);

		//overwrite some settings
		$settings = array_merge(
			$this->tpl_module["settings"],
			array(
				"set_date"			=> $this->tpl_module["settings"]["set_date_details"],
				"set_media_height"	=> $this->tpl_module["settings"]["set_media_height_details"],
			)
		);

		$template = &$this->private->templates["item"];
		$this->ProcessElements($item , $elements , $template , "listing" , $settings);



		$this->plugins["seo"]->PageMeta($item);
		$this->plugins["seo"]->Canonical($item["link"]);
		$this->plugins["media"]->OpenGraph($item["item_id"], $item["module_id"]);
		$this->plugins["seo"]->OpenGraph(array("og:type" => "article"));


		$text = $this->pageTitleBlock(array(
			$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
			$item["link"]				=> $item["item_title"]
		));

	

		$item["homepage"] = $this->tpl_module["link"];


		$item["social_links"] = $this->plugins["socialmedia"] && $this->tpl_module["settings"]["set_social_details"] ? $this->plugins["socialmedia"]->Share($item["link"]) : "";


		$item["next_link"] = $this->ItemLink($item , "next");
		$item["back_link"] = $this->ItemLink($item , "back");


		$item["next"] = $item["next_link"] ? $template->blockReplace("Next" , $item) : "";
		$item["back"] = $item["back_link"] ? $template->blockReplace("Back" , $item) : "";


		$this->SetComments($this->tpl_module["settings"]["set_comments_details"], 
			array(
				"reserved"	=> $item["item_id"],
				"status"	=> $item["item_comments"],
				"new"		=> !$item["item_comments_new"],
			)
		);

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_item"],
				$this->tpl_module["mod_protected"]
			),
			CTemplateStatic::Replace(
				$template->blockREplacE(
					"Main" , 
					$item
				),
				$this->tpl_module["settings"]
			)			
		);	
	}

	
	function ItemLink($parent , $type) {

		switch ($type) {
			case "next":

				$item = $this->db->QFetchArray(
					"SELECT * FROM 
						{$this->tables['plugin:news_items']} as i,
						{$this->tables['plugin:news_items_lang']} as il
					WHERE
						i.item_id = il.item_id AND 
						il.lang_id = {$this->tpl_module[lang_id]} AND
						i.item_id > {$parent[item_id]}

					ORDER BY 
						i.item_id ASC 
					LIMIT 1
					"
				);

				if (!is_array($item)) {			
					return ""; //$this->tpl_module["link"] ;
				} else {
					return $this->tpl_module["link"] . $item["item_id"] . "-" . $item["item_url"] ;
				}				
			break;

			case "back":

				$item = $this->db->QFetchArray(
					"SELECT * FROM 
						{$this->tables['plugin:news_items']} as i,
						{$this->tables['plugin:news_items_lang']} as il
					WHERE
						i.item_id = il.item_id AND 
						il.lang_id = {$this->tpl_module[lang_id]} AND
						i.item_id < {$parent[item_id]}

					ORDER BY 
						i.item_id DESC
					LIMIT 1
					"
				);

				if (!is_array($item)) {			
					return "";//$this->tpl_module["link"] ;
				} else {
					return $this->tpl_module["link"] . $item["item_id"] . "-" . $item["item_url"] ;
				}				

			break;
		}		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCommentPost($comment) {
		if ((int)$comment["comment_reserved"]) {
			$this->db->QueryUpdate(
				$this->tables["plugin:news_items"],
				array(
					"item_stats_comments"	=> $this->db->RowCount(
						$this->tables["plugin:comments"],
						"WHERE module_id={$comment[module_id]} AND comment_reserved={$comment[comment_reserved]}" 
					)
				),
				"item_id={$comment[comment_reserved]}"
			);
		}
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}


	function SitemapGetLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		$items = $this->db->QFetchRowArray(
			"SELECT 
				c.item_id , item_date , item_url 
			FROM 
				{$this->tables['plugin:news_items']} as c,
				{$this->tables['plugin:news_items_lang']} as l
			WHERE 					
				c.item_id=l.item_id AND 
				l.lang_id={$module[lang_id]} AND 
				c.module_id={$module[mod_id]} AND 
				item_status=1 AND 
				item_date <=  " . time()				
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$links[] = array(
					"lastmod"	=> $val["item_date"],
					"url"		=> $module["link"] .$val["item_url"] . "/" . $val["item_id"] 
				);
			}
			
		}
		
	}
}

?>